//------------------------------------------------------------------------------
// File: svr_cmdsystem.cs
// This file is used for initializing the command system on the server
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Initializes the server command system
////////////////////////////////////////////////////////////////////////////////
function slgBuildServerCommandSystem()
{
   slgBuildCommandSystem(true);   
   
   // Command handlers server-side
   slgAIRegisterCommands();
   CmdDispatcher.notifyOnCmdRequest($CSC_BUILD, "onBuildCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_EMPLOY, "onEmployCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_PICKUP, "onPropCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_QUICKJOB, "onPropCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_REPAIR, "onRepairCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_TOOL, "onToolCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_FIGHTFIRE, "onFightFireCommand");
   CmdDispatcher.notifyOnCmdRequest($CSC_REFORM, "onReformCommand");
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys the command system and stops it running
////////////////////////////////////////////////////////////////////////////////
function slgDestroyServerCommandSystem()
{   
   slgShutdownCommandSystem();
}

////////////////////////////////////////////////////////////////////////////////
//! This method is used by the server for commands reliant on server creation
//! (buildings and tools). If the creation fails in anyway, this method should
//! be called.
//! \param %cmd Command that failed
//! \param %error Error message for failure (prints to game screen)
////////////////////////////////////////////////////////////////////////////////
function csCmdStatusFail(%client, %cmd, %error)
{
   commandToClient(%client, 'CmdStatusFail', %cmd);
   if(%error !$= "") {
      tsSendAlertMessage(%error);
   }
}

// End svr_cmdsystem.cs
